/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.appserver;

import filenet.sim.appserver.IVWSIMCommand;
import filenet.sim.appserver.VWSIMSOAPUtils;
import filenet.vw.base.logging.Logger;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import java.rmi.RemoteException;

public class VWSIMCommand
implements IVWSIMCommand {
    protected static Logger logger = Logger.getLogger("filenet.sim.appserver");
    private static String m_className = "VWSIMCommand";
    private String m_url = null;
    private String m_token = null;
    private String m_sessionId = null;

    public VWSIMCommand(String url, String token) {
        this.m_url = url;
        this.m_token = token;
        try {
            this.m_sessionId = (String)VWIDMBaseFactory.instance().getProperties().getProperty("sessionId");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getUrl() {
        return this.m_url;
    }

    public String startSimulation(String scenarioXML, String optionsXML) throws RemoteException, Exception {
        String m_method = "startSimulation";
        String simGuid = null;
        Object p = null;
        try {
            logger.entering(m_className, "startSimulation");
            p = VWSIMSOAPUtils.invoke(this.m_url, "startSimulation", new String[]{"scenarioXML", "optionsXML"}, new Object[]{scenarioXML, optionsXML}, new Class[]{String.class, String.class}, this.m_token, this.m_sessionId);
            simGuid = (String)p;
            logger.exiting(m_className, "startSimulation");
        }
        catch (Exception e) {
            logger.throwing(m_className, "startSimulation", e);
            throw e;
        }
        return simGuid;
    }

    public void stopSimulation(String simGuid) throws RemoteException, Exception {
        String m_method = "stopSimulation:" + simGuid;
        try {
            logger.entering(m_className, m_method);
            VWSIMSOAPUtils.invoke(this.m_url, "stopSimulation", new String[]{"simGuid"}, new Object[]{simGuid}, new Class[]{String.class}, this.m_token, this.m_sessionId);
            logger.exiting(m_className, m_method);
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            throw e;
        }
    }

    public int getStatus(String simGuid) throws RemoteException, Exception {
        String m_method = "getStatus:" + simGuid;
        int status = 0;
        try {
            logger.entering(m_className, m_method);
            Object p = null;
            p = VWSIMSOAPUtils.invoke(this.m_url, "getStatus", new String[]{"simGuid"}, new Object[]{simGuid}, new Class[]{String.class}, this.m_token, this.m_sessionId);
            status = (Integer)p;
            logger.exiting(m_className, m_method);
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            throw e;
        }
        return status;
    }

    protected void cleanup() {
        String m_method = "cleanup";
        try {
            logger.entering(m_className, "cleanup");
            VWSIMSOAPUtils.invoke(this.m_url, "cleanup", null, null, null, null, this.m_sessionId);
            logger.exiting(m_className, "cleanup");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[][] readSimulationData(String simGuid, String clientIDContext, int maxRecords) throws RemoteException, Exception {
        String m_method = "readSimulationData:" + simGuid;
        Object p = null;
        byte[][] data = null;
        try {
            if (clientIDContext == null) {
                throw new Exception("need to initialized the Client ID Context..");
            }
            logger.entering(m_className, m_method);
            p = VWSIMSOAPUtils.invoke(this.m_url, "readSimulationData", new String[]{"simGuid", "clientIDContext", "maxRecords"}, new Object[]{simGuid, clientIDContext, new Integer(maxRecords)}, new Class[]{String.class, String.class, Integer.class}, this.m_token, this.m_sessionId);
            data = (byte[][])p;
            logger.exiting(m_className, m_method);
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            throw e;
        }
        return data;
    }

    public void startPublish(String simGuid) throws RemoteException, Exception {
        String m_method = "startPublish:" + simGuid;
        try {
            logger.entering(m_className, m_method);
            VWSIMSOAPUtils.invoke(this.m_url, "publishData", new String[]{"startOrStop", "simGuid"}, new Object[]{new Integer(1), simGuid}, new Class[]{Integer.class, String.class}, this.m_token, this.m_sessionId);
            logger.exiting(m_className, m_method);
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            throw e;
        }
    }

    public void stopPublish(String simGuid) throws RemoteException, Exception {
        String m_method = "stopPublish:" + simGuid;
        try {
            logger.entering(m_className, m_method);
            VWSIMSOAPUtils.invoke(this.m_url, "publishData", new String[]{"startOrStop", "simGuid"}, new Object[]{new Integer(0), simGuid}, new Class[]{Integer.class, String.class}, this.m_token, this.m_sessionId);
            logger.exiting(m_className, m_method);
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            throw e;
        }
    }

    public byte[] getPublishedSimulations(String user, byte[] token, int maxRecords) throws RemoteException, Exception {
        String m_method = "getPublishedSimulations:" + user;
        try {
            logger.entering(m_className, m_method);
            byte[] queryResult = null;
            Object p = VWSIMSOAPUtils.invoke(this.m_url, "getPublishedSimulations", new String[]{"user", "token", "maxRecords"}, new Object[]{user, token, new Integer(maxRecords)}, new Class[]{String.class, byte[].class, Integer.class}, this.m_token, this.m_sessionId);
            queryResult = (byte[])p;
            logger.exiting(m_className, m_method);
            return queryResult;
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            throw e;
        }
    }

    public void deletePublishedData(byte[] publishedSimulations) throws RemoteException, Exception {
        String m_method = "deletePublishedData";
        try {
            logger.entering(m_className, "deletePublishedData");
            VWSIMSOAPUtils.invoke(this.m_url, "deletePublishedData", new String[]{"publishedSimulations"}, new Object[]{publishedSimulations}, new Class[]{byte[].class}, this.m_token, this.m_sessionId);
            logger.exiting(m_className, "deletePublishedData");
        }
        catch (Exception e) {
            logger.throwing(m_className, "deletePublishedData", e);
            throw e;
        }
    }

    protected void finalize() {
        this.cleanup();
    }

    public String getStatistics(String simGuid) throws RemoteException, Exception {
        String m_method = "getStatistics:" + simGuid;
        String stats = null;
        try {
            logger.entering(m_className, m_method);
            Object p = null;
            stats = (String)VWSIMSOAPUtils.invoke(this.m_url, "getStatistics", new String[]{"simGuid"}, new Object[]{simGuid}, new Class[]{String.class}, this.m_token, this.m_sessionId);
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "stats=" + stats);
            }
            logger.exiting(m_className, m_method);
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
            throw e;
        }
        return stats;
    }
}

